//=============================================================================
// Personal Portal Gun
//=============================================================================
class PersonalPortalGun extends DeusExWeapon;

#exec OBJ LOAD FILE=MSPGFX

var PersonalYellowPortal yportal;
var PersonalBluePortal bportal;
var travel byte ColorMode;
var localized String msgPortalFailure;
var localized String msgHasPortals;
var Bool yportalexists;
var Bool bportalexists;
var Bool bBlueFire;
var Bool bYellowFire;
//var Bool bCarryingThing;

simulated function SwapMuzzleFlashTexture()
{
   	if ( !bHasMuzzleFlash )
      		return;  

	if (bYellowFire)
	{
		MultiSkins[2] = Texture'YPortalFlash';
		SetTimer(0.2, False);
	}
	if (bBlueFire)
	{
		MultiSkins[2] = Texture'BPortalFlash';
		SetTimer(0.2, False);
	}
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
local PersonalYellowPortal yportal;
local PersonalBluePortal bportal;
local DeusExPlayer P;
P = DeusExPlayer(Owner);
if ( P != None )    
{ 
  if (ColorMode == 0)
  {
   if ((Other != None) && Other.IsA('Pawn') || Other.IsA('Decoration') || Other.IsA('PortalBlocker'))
   {
		Pawn(Owner).ClientMessage(msgPortalFailure);
		return;
    bYellowFire = False;
    bBlueFire = True;
   }
   else
   {
    if (!bportalexists)
    {
    ColorMode = 1;
    bportal = spawn(class'PersonalBluePortal',P,,HitLocation);
    bportalexists = True;
    bYellowFire = False;
    bBlueFire = True;
    }
    else if (bportalexists)
    {
    Pawn(Owner).ClientMessage(msgHasPortals);
    bYellowFire = False;
    bBlueFire = True;
    }
   }
  }
  else if (ColorMode == 1)
  {
   if ((Other != None) && Other.IsA('Pawn') || Other.IsA('Decoration') || Other.IsA('PortalBlocker'))
   {
		Pawn(Owner).ClientMessage(msgPortalFailure);
		return;
       bYellowFire = True;
       bBlueFire = False;
   }
   else
   {
    if (!yportalexists)
    {
    ColorMode = 0;
    yportal = spawn(class'PersonalYellowPortal',P,,HitLocation);
    yportalexists = True;
    bYellowFire = True;
    bBlueFire = False;
    }
    else if (yportalexists)
    {
    Pawn(Owner).ClientMessage(msgHasPortals);
    bYellowFire = True;
    bBlueFire = False;
    }
   }

  }
}
}
//Other.SetBase(P);

function LaserToggle()
{
local DeusExPlayer P;
P = DeusExPlayer(Owner);
    ForEach AllActors(class'PersonalYellowPortal',yportal)
    {
    if (yportal != None)  
      {
      if (yportal.Owner != P)
          {
          return;
          }
      else
          {
          yportal.Destroy();
          }
      }
    }
    ForEach AllActors(class'PersonalBluePortal',bportal)
    {    
    if (bportal != None) 
      {
      if (bportal.Owner != P)
          {
          return;
          }
      else
          {
          bportal.Destroy();
          }
      }
    }
    bportalexists = False;
    yportalexists = False;
    ColorMode = 0;
}

defaultproperties
{
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     ShotTime=0.500000
     reloadTime=0.000001
     bWeaponStay=True
     PickupAmmoCount=10
     HitDamage=300
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True
     recoilStrength=1.000000
     bUseWhileCrouched=False
     mpHitDamage=40
     mpAccurateRange=14400
     mpMaxRange=14400
     mpReloadCount=1
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-25.000000,Y=8.000000,Z=14.000000)
     ProjectileClass=None
     shakemag=0.000000
     FireSound=Sound'DeusExSounds.Weapons.LAWFire'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=254
     ItemArticle="|p1a"
     ItemName="|p1Markistan Corp Personal Portal Gun"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Glock'
     PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
     largeIconWidth=46
     largeIconHeight=28
     invSlotsX=2
     Description="A mysterious gun that seems remotely familiar... this version has been modified for civlian purposes only"
     beltDescription="MINI-PORT"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=7.000000
     CollisionHeight=1.000000
     Mass=5.000000
     msgPortalFailure="Invalid Location."
     msgHasPortals="Portals already in use."
     PickupMessage="|p4Use your laser toggle button (|p3]|p4 by default) to erase portals. |p1You have obtained"
     bCanHaveScope=True
     bHasScope=True
     BaseAccuracy=0.000000
     bEmitWeaponDrawn=False
     bBlueFire=True
}
